﻿using System;
using System.Collections.Generic;

namespace YieldReturn
{
    // Listing 7-33. Prezentacja działania instrukcji yield return.
    class Program
    {
        static IEnumerable<string> AddNumbers(IEnumerable<string> names)
        {
            Console.WriteLine("Zaczynamy metodę AddNumbers.");
            int i = 0;
            foreach (string currentName in names)
            {
                Console.WriteLine("W metodzie AddNumbers: " + currentName);
                yield return string.Format("{0}. {1}.", i, currentName);
                i += 1;
            }
            Console.WriteLine("Kończymy metodę AddNumbers.");
        }

        static void Main(string[] args)
        {
            string[] eventNames =
            {
                "Swingowa potańcówka na nabrzeżu",
                "Sobotnia noc swingowa",
                "Formula 1 - Grand Prix Niemiec",
                "Piknik swingowy",
                "Łamańce swingowe w klubie Setka"
            };

            Console.WriteLine("Wywołujemy metodę AddNumbers.");
            IEnumerable<string> numberedNames = AddNumbers(eventNames);
            Console.WriteLine("Zaczynamy wykonywać główną pętlę.");
            foreach (string numberedName in numberedNames)
            {
                Console.WriteLine("W głównej pętli: " + numberedName);
            }
            Console.WriteLine("Koniec głównej pętli.");
        }
    }
}
